<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for the quizaccess_schoolyear plugin.
 *
 * @package    quizaccess_schoolyear
 * @copyright  2023 Schoolyear B.V.
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Schoolyear';
$string['schoolyearenabled'] = 'Schoolyear Exams';
$string['schoolyearenabledoption'] = 'enabled';
$string['schoolyeardisabledoption'] = 'disabled';
$string['requiresschoolyear'] = 'This quiz requires the Schoolyear application.';
$string['errorverifying'] = 'An error occurred while verifying Schoolyear browser.';
$string['invaliduseridnumber'] = 'Your user ID is empty. You need a user ID to start a Schoolyear exam.';
$string['startquiz'] = 'Start quiz';
$string['settingswidget'] = 'Settings widget';
$string['opensettingswidget'] = 'Open settings widget';
$string['dashboard'] = 'Dashboard';
$string['opendashboard'] = 'Open dashboard';
$string['savefirst'] = 'Save to access the settings and dashboard buttons for this exam.';
$string['timingerror'] = 'Opening and closing time must be set for a Schoolyear exam.';
$string['apibaseaddress'] = 'Schoolyear API base address';
$string['apikey'] = 'Schoolyear API key';
$string['orgcodemissing'] = 'Your account does not have a student ID number, which is required to start an exam with Schoolyear. Contact your Administrator.';
$string['privacy:metadata:schoolyear'] = 'In order to integrate with Schoolyear, user data needs to be exchanged with Schoolyear services.';
$string['privacy:metadata:schoolyear:userid'] = 'The userid is sent from Moodle to allow Schoolyear to distinguish users.';
$string['privacy:metadata:schoolyear:idnumber'] = 'The idnumber is sent from Moodle to allow Schoolyear to identify users.';
$string['privacy:metadata:schoolyear:firstname'] = 'Your first name is sent to Schoolyear to allow a better user experience.';
$string['privacy:metadata:schoolyear:lastname'] = 'Your last name is sent to Schoolyear to allow a better user experience.';
